<?php
/*
Plugin Name: Editor Wysiwyg Background Color
Plugin URI:
Description: A color picker for change the Wysiwyg editor background color.
Author: FADI Mohamed
Version: 1.0
Text Domain: editor-wysiwyg-background-color
Domain Path: /languages
License: GPLv2 or later
Domain Path: /languages
*/

add_action('after_setup_theme', 'ewbc_theme_setup');
if (!function_exists('ewbc_theme_setup')) {
    function ewbc_theme_setup()
    {
        add_action('init', 'ewbc_buttons');
    }
}
add_action('wp_enqueue_editor', 'ewbc_enqueue_editor');
function ewbc_enqueue_editor($args)
{
    if (!empty($args['tinymce'])) {
        wp_enqueue_style('ewbc', plugin_dir_url(__FILE__) . 'css/ewbc.css');
        //  wp_enqueue_script('wp-color-picker');
    }
}

if (!function_exists('ewbc_buttons')) {
    function ewbc_buttons()
    {
        if (!current_user_can('edit_posts') && !current_user_can('edit_pages')) {
            return;
        }
        if (get_user_option('rich_editing') !== 'true') {
            return;
        }
        add_filter('mce_external_plugins', 'ewbc_add_buttons');
        add_filter('mce_buttons', 'ewbc_register_buttons');
    }
}
if (!function_exists('ewbc_add_buttons')) {
    function ewbc_add_buttons($plugin_array)
    {
        $plugin_array['ewbc-notify'] = plugin_dir_url(__FILE__) . 'js/ewbc-growl.js';
        $plugin_array['ewbc'] = plugin_dir_url(__FILE__) . 'js/ewbc.js';
        return $plugin_array;
    }
}
if (!function_exists('ewbc_register_buttons')) {
    function ewbc_register_buttons($buttons)
    {
        array_push($buttons, 'ewbc');
        return $buttons;
    }
}
add_action('wp_ajax_ewbc_get_data', 'ewbc_get_data');
add_action('wp_ajax_nopriv_ewbc_get_data', 'ewbc_get_data');
function ewbc_get_data()
{
    extract($_POST);
    if (!isset($post_ID) && empty($post_ID) && empty($id))
        return false;
    $data = get_post_meta($post_ID, 'ewbc-' . $id, true);
    echo $data;
    die();
}

add_action('wp_ajax_ewbc_save_data', 'ewbc_save_data');
add_action('wp_ajax_nopriv_ewbc_save_data', 'ewbc_save_data');
function ewbc_save_data()
{
    extract($_POST);
    if (!isset($post_ID) && empty($post_ID) && empty($ewbc))
        return false;
    $return = array();
    $ewbc = update_post_meta($post_ID, 'ewbc-' . $ewbc[1], $ewbc[0]);
    if ($ewbc) {
        $return['status'] = 1;
        $return['msg'] = __('Background color changed successfully', 'editor-wysiwyg-background-color');
        echo json_encode($return);
        die();
    } else if (empty($ewbc)) {
        $return['status'] = 2;
        $return['msg'] = __('Background color changed successfully', 'editor-wysiwyg-background-color');
        echo json_encode($return);
        die();
    } else {
        $return['status'] = 0;
        $return['msg'] = __('error', 'ewbc');
        echo json_encode($return);
        die();
    }
}

add_action('plugins_loaded', 'ewbc_load_plugin_textdomain');
function ewbc_load_plugin_textdomain()
{
    load_plugin_textdomain('editor-wysiwyg-background-color', FALSE, dirname(plugin_basename(__FILE__)) . '/languages');
}
